-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then 
    self.initialized = true
    self.player0 = Citadels.GetPlayer(0)
    --self.player1 = Citadels.GetPlayer(1)
    self.castleDestroyed:LinkToTarget("defeat")
    self.deactivateArmyCond:LinkToTarget("condDeact")
  end  
end

function OnBeforeDeath(self)
  self.castleDestroyed:TriggerAllTargets()
end

function OnTrigger(self, source, target)
  if target == "changeOwner" then
    self.player0:SwitchOwnership(Game:GetEntity(self:GetKey()), 0)
    self.deactivateArmyCond:TriggerAllTargets()
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("changeOwner")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("castleDestroyed") 
  self:AddTriggerSource("deactivateArmyCond")
end
